IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CPJ_Cobros_Pendientes]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CPJ_Cobros_Pendientes] 
END
GO


CREATE PROCEDURE [dbo].[CPJ_Cobros_Pendientes] @pJson VARCHAR(8000)
AS 
BEGIN
SET NOCOUNT ON

DECLARE	@pFiltrar_Fecha		TINYINT 
	,@pFecha_Desde			DATETIME 
	,@pFecha_Hasta			DATETIME
	,@pId_cliente			INT
	,@pDoc_Nro				BIGINT
	,@pId_Cobrador			VARCHAR(10)
	,@pId_Cliente_Externo	VARCHAR(50)
	,@pDet_Producto			INT=0


SET @pFiltrar_Fecha			= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'Filtrar_Fecha')), 0)
SET @pFecha_Desde			= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Desde'))
SET @pFecha_Hasta			= CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Hasta'))
SET @pId_cliente			= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Cobrador			= ISNULL(CONVERT(VARCHAR(10), dbo.CF_JSON_VALUE(@pJson,'Id_Cobrador')), '')
SET @pDoc_Nro				= ISNULL(CONVERT(BIGINT, dbo.CF_JSON_VALUE(@pJson,'Doc_Nro')), 0)
SET @pId_Cliente_Externo	= ISNULL(CONVERT(VARCHAR(50), dbo.CF_JSON_VALUE(@pJson,'Id_Cliente_Externo')), '')
SET @pDet_Producto		    = ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Det_Producto')), 0)


DECLARE @Sql		VARCHAR(MAX)
DECLARE @SqlSaldo	VARCHAR(MAX)
DECLARE @SqlSelect	VARCHAR(MAX)
DECLARE @SqlFrom	VARCHAR(MAX)
DECLARE @SqlWhere	VARCHAR(MAX)
DECLARE @SqlGroup	VARCHAR(MAX)

CREATE TABLE #Cobros_Pend  (
			 Fecha DATETIME
			,Fecha_Vence DATETIME
			,Descripcion VARCHAR(25)
			,Id_Trans INT
			,Nro_Cuota SMALLINT
			,Id_cliente INT
			,Razon_Social CHAR(100)
			,Importe DECIMAL(16,2)
			,Saldo 	DECIMAL(16,2)
			,Id_Tipo_Cbte Char(4)
			,Comprobante_Nro INT
			,Id_Estado_Cbte SMALLINT
			,Id_Cobrador Varchar(10)
			,Nombre_Cobrador CHAR(100)
			,Id_Interno INT IDENTITY(1,1)
			,Activo TINYINT
			,Descrip_Producto	VARCHAR(8000)
			,Doc_Nro	BIGINT
			,Id_Cliente_Externo VARCHAR(50)
		)

IF @pId_cliente = 0 AND @pDoc_Nro <> 0
	SELECT TOP 1 @pId_cliente = Id_cliente FROM Clientes WHERE Doc_Nro = @pDoc_Nro ORDER BY Activo  DESC

IF @pId_cliente = 0 AND @pDoc_Nro = 0 AND @pId_Cliente_Externo <> ''
	SELECT TOP 1 @pId_cliente = Id_cliente FROM Clientes WHERE Id_Cliente_Externo = @pId_Cliente_Externo ORDER BY Activo  DESC


IF  @pId_cliente = 0  AND (@pDoc_Nro <> 0 OR @pId_Cliente_Externo <> '')
BEGIN
	SELECT * FROM #Cobros_Pend
	DROP TABLE #Cobros_Pend 
	RETURN 0
END


SET @SqlSelect = 'SELECT TOP 50 k.FECHA as Fecha,
                         k.Fecha_vence as Fecha_Vence,
						 k.Descripcion as Descripcion,
						 k.Id_Trans as Id_Trans,
						 k.Nro_Cuota as Nro_Cuota,
						 k.Id_cliente as Id_Cliente,
						 UPPER(CL.Razon_Social) as Razon_Social,
						 K.Importe as Importe,
						 k.Saldo as Saldo,
						 C.Id_Tipo_Cbte as Id_Tipo_Cbte,
						 C.Comprobante_Nro as Comprobante_Nro,
						 k.Id_Estado_Cbte as Id_Estado_Cbte,
						 UPPER(CL.id_COBRADOR) as Id_Cobrador,
						 V.Descripcion as Nombre_Cobrador,
						 CL.Activo
						'
						 

IF (@pDet_Producto<>0)
BEGIN
	SET @SqlSelect =@SqlSelect+ ',dbo.CF_Descrip_Cbte_Producto(C.Id_Trans) AS Det_Producto'
END 
ELSE
BEGIN
	SET @SqlSelect =@SqlSelect+ ','''' AS Det_Producto'
END 
SET @SqlSelect =@SqlSelect+ ',CL.Doc_Nro
						 ,CL.Id_Cliente_Externo'

SET @SqlFrom = 'FROM  Cbtes C , Clientes_Ctacte K, Clientes CL,  Cbtes_Tipos T,  Vendedores V'
----------------------------------------------------------------------------------------------------------------------
SET @SqlWhere = ' WHERE c.id_trans = k.id_trans 
                        AND K.ID_CLIENTE = CL.ID_CLIENTE
						AND C.ID_TIPO_CBTE = T.ID_TIPO_CBTE
						AND CL.ID_COBRADOR = V.ID_VENDEDOR 
						AND K.ID_ESTADO_CBTE IN (1,4)
						AND T.COMPROMETE_FACTURA IN (1)
						AND K.SALDO <> 0'
						

					 
IF @pId_cliente <> 0
  BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND C.Id_cliente  = ' +  cast(@pId_cliente  as varchar(12))
  END


IF ISNULL(@pId_Cobrador,'') <> '' AND @pId_cliente = 0
	BEGIN
		SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND CL.Id_Cobrador = ''' + @pId_Cobrador + ''''
	END


IF ISNULL(@pFiltrar_Fecha,0) <> 0
BEGIN
	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE >= '''+ CONVERT(VARCHAR(8),@pFecha_Desde,112) +''''

	SET @SqlWhere = RTRIM(LTRIM(@SqlWhere)) + ' AND k.FECHA_VENCE < '''+ CONVERT(VARCHAR(8),@pFecha_Hasta+1,112) +''''
END
----------------------------------------------------------------------------------------------------------------------
SET @SqlGroup = ' ORDER BY CL.Activo DESC,k.id_cliente,k.FECHA_VENCE '


SET @Sql = @SqlSelect +' '+ @SqlFrom + ' ' + @SqlWhere + ' ' + @SqlGroup 
PRINT @Sql
--EXECUTE (@Sql) 

CREATE INDEX IX_cobros_Pend____ ON  #Cobros_Pend (Id_Interno)

INSERT INTO #Cobros_Pend
EXEC(@sql)

SELECT * FROM #Cobros_Pend


DROP TABLE #Cobros_Pend 

END


/*


EXEC [CPJ_Cobros_Pendientes] '{"Filtrar_Fecha":"0"
					,"Fecha_Desde":""
					,"Fecha_Hasta":""
					,"Id_Cliente":"10533"
					,"Id_Cobrador":""
					,"Doc_Nro":""
					,"Det_Producto":""}'


*/